/*
 * Decompiled with CFR 0.152.
 */
package net.hadrus.alcocraft.blocks.workstations;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.Random;
import net.hadrus.alcocraft.blocks.AlcoBlockEntities;
import net.hadrus.alcocraft.gui.KegMenu;
import net.hadrus.alcocraft.items.AlcoItems;
import net.hadrus.alcocraft.recipes.KegRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class KegBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            KegBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return KegBlockEntity.this.progress;
                }
                case 1: {
                    return KegBlockEntity.this.maxProgress;
                }
                case 2: {
                    return KegBlockEntity.this.waterLevel;
                }
                case 3: {
                    return KegBlockEntity.this.beerLevel;
                }
                case 4: {
                    return KegBlockEntity.this.beerType;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    KegBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    KegBlockEntity.this.maxProgress = value;
                    break;
                }
                case 2: {
                    KegBlockEntity.this.waterLevel = value;
                    break;
                }
                case 3: {
                    KegBlockEntity.this.beerLevel = value;
                    break;
                }
                case 4: {
                    KegBlockEntity.this.beerType = value;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };
    private int progress = 0;
    private int maxProgress = 18000;
    public int waterLevel = 0;
    public int maxWaterLevel = 40;
    public int beerLevel = 0;
    public int beerType = 0;
    private static final Logger LOGGER = LogUtils.getLogger();

    public KegBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)AlcoBlockEntities.KEG_ENTITY.get(), blockPos, blockState);
    }

    public Component m_5446_() {
        return new TextComponent("Keg");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new KegMenu(containerId, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("gem_cutting_station.progress", this.progress);
        tag.m_128405_("water", this.waterLevel);
        tag.m_128405_("beer", this.beerLevel);
        tag.m_128405_("beerType", this.beerType);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("gem_cutting_station.progress");
        this.waterLevel = tag.m_128451_("water");
        this.beerLevel = tag.m_128451_("beer");
        this.beerType = tag.m_128451_("beerType");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, KegBlockEntity pBlockEntity) {
        Random random = pLevel.f_46441_;
        if (KegBlockEntity.hasRecipe(pBlockEntity)) {
            ++pBlockEntity.progress;
            KegBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (random.nextFloat() < 0.005f) {
                pLevel.m_5594_(null, pPos, SoundEvents.f_12030_, SoundSource.BLOCKS, 0.1f, 0.5f);
            }
            if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                KegBlockEntity.craftItem(pBlockEntity);
            }
        } else {
            pBlockEntity.resetProgress();
            KegBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private static boolean hasRecipe(KegBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional match = level.m_7465_().m_44015_((RecipeType)KegRecipe.Type.INSTANCE, (Container)inventory, level);
        return match.isPresent() && KegBlockEntity.hasWater(entity) && !KegBlockEntity.hasBeer(entity);
    }

    private static boolean hasWater(KegBlockEntity entity) {
        return entity.waterLevel != 0;
    }

    private static boolean hasBeer(KegBlockEntity entity) {
        return entity.beerLevel != 0;
    }

    private static void craftItem(KegBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional match = level.m_7465_().m_44015_((RecipeType)KegRecipe.Type.INSTANCE, (Container)inventory, level);
        if (match.isPresent()) {
            entity.itemHandler.extractItem(0, 1, false);
            entity.itemHandler.extractItem(1, 1, false);
            entity.itemHandler.extractItem(2, 1, false);
            entity.itemHandler.extractItem(3, 1, false);
            if (((KegRecipe)match.get()).m_8043_().m_41720_().equals(AlcoItems.SPRUCE_MUG_SUN_PALE_ALE.get())) {
                entity.beerType = 1;
            } else if (((KegRecipe)match.get()).m_8043_().m_41720_().equals(AlcoItems.SPRUCE_MUG_DIGGER_BITTER.get())) {
                entity.beerType = 2;
            } else if (((KegRecipe)match.get()).m_8043_().m_41720_().equals(AlcoItems.SPRUCE_MUG_NETHER_PORTER.get())) {
                entity.beerType = 3;
            } else if (((KegRecipe)match.get()).m_8043_().m_41720_().equals(AlcoItems.SPRUCE_MUG_WITHER_STOUT.get())) {
                entity.beerType = 4;
            } else if (((KegRecipe)match.get()).m_8043_().m_41720_().equals(AlcoItems.SPRUCE_MUG_MAGNET_PILSNER.get())) {
                entity.beerType = 5;
            } else if (((KegRecipe)match.get()).m_8043_().m_41720_().equals(AlcoItems.SPRUCE_MUG_DROWNED_ALE.get())) {
                entity.beerType = 6;
            } else if (((KegRecipe)match.get()).m_8043_().m_41720_().equals(AlcoItems.SPRUCE_MUG_NIGHT_RAUCH.get())) {
                entity.beerType = 7;
            } else if (((KegRecipe)match.get()).m_8043_().m_41720_().equals(AlcoItems.SPRUCE_MUG_ICE_BEER.get())) {
                entity.beerType = 8;
            } else if (((KegRecipe)match.get()).m_8043_().m_41720_().equals(AlcoItems.SPRUCE_MUG_KVASS.get())) {
                entity.beerType = 9;
            } else if (((KegRecipe)match.get()).m_8043_().m_41720_().equals(AlcoItems.SPRUCE_MUG_LEPRECHAUN_CIDER.get())) {
                entity.beerType = 10;
            } else if (((KegRecipe)match.get()).m_8043_().m_41720_().equals(AlcoItems.SPRUCE_MUG_CHORUS_ALE.get())) {
                entity.beerType = 11;
            } else if (((KegRecipe)match.get()).m_8043_().m_41720_().equals(AlcoItems.SPRUCE_MUG_NETHER_STAR_LAGER.get())) {
                entity.beerType = 12;
            }
            entity.beerLevel = entity.waterLevel;
            entity.waterLevel = 0;
            entity.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }
}

